<?php

namespace App\Http\Controllers\VolApp;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VolunteerController extends Controller
{
    public function sync()
    {
        $hes = request("hes");
        foreach ($hes as $he) {
            $heModel = new \App\Models\HeActivity;
            $heModel->n_o_attendence_male = $he["male"];
            $heModel->n_o_attendence_female = $he["female"];
            $heModel->date = $he["date"];
            $heModel->month = $he["month"];
            $heModel->year = $he["year"];
            $heModel->remark = $he["remark"];
            $heModel->place = $he["address"];
            $heModel->type = $he["type"] == "community" ? 1 : 2;
            $heModel->volunteer_id = request()->user()->id;
            $heModel->township_id = request()->user()->township_id;
            $heModel->save();
        }
        $mytime = \Carbon\Carbon::now();
        $patients = request("patients");
        foreach ($patients as $p) {
            $pModel = new \App\Models\Presumptive;
            $pModel->referral_from_id = 1;
            $pModel->name = $p["name"];
            $pModel->age = $p["age"];
            $pModel->sex = $p["gender"];
            $pModel->case_found_at = $p["type"];

            if ($pModel->case_found_at  == 3 || $pModel->case_found_at  == 5) {
                $pModel->index_case_no  = $p["code"];
                $pModel->index_case_year = $p["year"];
                $pModel->relationship = $p["household"] == "household" ? 1 : 2;
            }

            $pModel->confirm = 0;
            $pModel->volunteer_id = request()->user()->id;
            $pModel->township_id = request()->user()->township_id;
            $pModel->referral_date = $mytime->toDateTimeString();
            $pModel->existing_presumptive = 1;
            $pModel->save();
        }

        $hes = \App\Models\HeActivity::where("volunteer_id", request()->user()->id)->get();
        $presumptives = \App\Models\Presumptive::where("volunteer_id", request()->user()->id)->where("status", 1)->get();

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patients", [
                "hes" => $hes,
                "patients" => $presumptives
            ])
        );
    }
}
