<?php

namespace App\Http\Controllers\VolApp;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class LoginController extends Controller
{
    private $authService;

    public function __construct()
    {
        parent::__construct();
        $this->authService = new \App\Service\VolApp\Auth;
    }

    public function login()
    {
        $validate_result = $this->validateData([
            "code" => "required",
            "password" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->authService->login();
        if (!$result) {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::LoginedFailed, false, "Login Failed"),
                \App\Enums\ResponseCode::LoginedFailed
            );
        } else {
            $tokenResult = $result->createToken('Volunteer Access Token');
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Login Success", array(
                    "token" => $tokenResult->accessToken,
                    "user" => $result,
                    "symptons" => \App\Models\Sympton::where("status", 1)->get(),
                ))
            );
        }
    }
}
