<?php

namespace App\Http\Controllers\Supervision;

use App\Http\Controllers\Controller;

class VisitController extends Controller
{
    private $visitService;

    public function __construct()
    {
        parent::__construct();
        $this->visitService = new \App\Service\Supervision\Visit;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'date' => 'required',
            'type_of_visit' => 'required',
            'township_ids' => 'required'

        ], request()->all());
        
        if ($validate_result) return $this->showValidateError();

        $result = $this->visitService->save();
        $result = $this->visitService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->visitService->getAll();
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Supervision Visit Activities",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->visitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'date' => 'required',
            // 'start_time' => 'required',
            // "end_time" => 'required',
            "place_of_visit" => 'required',
            'id' => 'required',
            "township_ids" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->visitService->update();
        $result = $this->visitService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->visitService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is deleted", $result)
        );
    }
}
