<?php

namespace App\Http\Controllers\Supervision;

use App\Http\Controllers\Controller;

class ReportController extends Controller
{
    private $reportService;

    public function __construct()
    {
        parent::__construct();
        $this->reportService = new \App\Service\Supervision\Report;
    }

    public function get(){
        $validate_result = $this->validateData([
            "member_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->reportService->get();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Report Member ID by " . request("member_id"), $result)
        );
    }

}