<?php

namespace App\Http\Controllers\Supervision;

use App\Http\Controllers\Controller;

class LoginController extends Controller
{
    private $supervisonAuthService;

    public function __construct()
    {
        parent::__construct();
        $this->supervisonAuthService = new \App\Service\Supervision\Auth;
    }

    public function login()
    {
        $validate_result = $this->validateData([
            "username" => "required",
            "password" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->supervisonAuthService->login(request()->all());
        if (!$result) {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::LoginedFailed, false, "Login Failed")
            );
        } else {
            $tokenResult = $result->createToken('Supervision Access Token');
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Login Success", array(
                    "token" => $tokenResult->accessToken,

                ))
            );
        }
    }
    public function getYour()
    {
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Your Information", array(
                "user" => $this->supervisonAuthService->getYour()
            ))
        );
    }
    public function logout()
    {
        request()->user()->OauthAcessToken()->delete();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Logout successfully")
        );
    }
}
