<?php

namespace App\Http\Controllers\Supervision;

use App\Http\Controllers\Controller;

class FeedbackController extends Controller
{
    private $feedbackService;

    public function __construct()
    {
        parent::__construct();
        $this->feedbackService = new \App\Service\Supervision\Feedback;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'sup_visit_id' => 'required',
            "body" => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->feedbackService->save();
        $result = $this->feedbackService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Feedback is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            'sup_visit_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->feedbackService->getAll();
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Supervision Visit Feedbacks",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->feedbackService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Feedback by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'sup_visit_id' => 'required',
            "body" => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->feedbackService->update();
        $result = $this->feedbackService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Feedback is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->feedbackService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Feedback is deleted", $result)
        );
    }
}
