<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class VolunteerController extends Controller
{
    private $volunteerService;

    public function __construct()
    {
        parent::__construct();
        $this->volunteerService = new \App\Service\PA\Volunteer;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'age' => 'required',
            'gender' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'education_status' => 'required',
            'occupation' => 'required',
            
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        $data=request()->all();
       
        $township=\App\Models\Township::where("id",request()->user()->township_id)->first();
        $data["short_code"]=$township->short_code;
        $data["township_name"]=$township->name;
        
      
        
        // $url = 'http://150.95.26.210/api/v1/volunteer_sync/save_volunteer_from_mdr';
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["data"=>$data]));
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $response = json_decode(curl_exec($ch));
        // if (curl_errno($ch)) {
        //     $error_message = curl_error($ch);
        //   return response()->json(["success"=>false,"error"=> $error_message]);
        // }
        
        $data["global_id"]= null;
        // $data["code"]=$response->data->code;

        $result = $this->volunteerService->save($data);
        $result = $this->volunteerService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer is Saved",  $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'age' => 'required',
            'gender' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'education_status' => 'required',
            'occupation' => 'required',
          //  'remark' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        $data=request()->all();
        $data["global_id"]=\App\Models\Volunteer::where("id",$data["id"])->first()->global_id;
        
        //  $url = 'http://150.95.26.210/api/v1/volunteer_sync/update_volunteer_from_mdr';
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(["data"=>$data]));
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // $response = json_decode(curl_exec($ch));
        // if (curl_errno($ch)) {
        //     $error_message = curl_error($ch);
        //   return response()->json(["success"=>false,"error"=> $error_message]);
        // }

        $result = $this->volunteerService->update(request()->all());
        $result = $this->volunteerService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer is edited", $result)
        );
    }

    public function get()
    {
        $result =  $this->volunteerService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All volunteers",
                $result
            )
        );
    }

    public function trash()
    {
        $result =  $this->volunteerService->trash(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All volunteers from trash",
                $result
            )
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->volunteerService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer is deleted", $result)
        );
    }

    public function recover()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->volunteerService->recover(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer is recovered", $result)
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->volunteerService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer by " . request("column"), $result));
    }
}
