<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class TownshipController extends Controller
{
    private $townshipService;

    public function __construct()
    {
        parent::__construct();
        $this->townshipService = new \App\Service\PA\Township;
    }



    public function get()
    {
        $result =  $this->townshipService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Townships",
                $result
            )
        );
    }
    
    public function getAll()
    {
        $result =  $this->townshipService->getAllTownships();
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All 24 Townships",
                $result
            )
        );
    }
}
