<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class SupervisionVisitActivityController extends Controller
{
    private $superVisionVisitService;

    public function __construct()
    {
        parent::__construct();
        $this->superVisionVisitService = new \App\Service\PA\SupervisionVisit;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'volunteer_id'=>'required',
          //  'patient_id'=>'required',
            "date" => 'required',
            
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        // Validation 
        $volunteer_id=request()->volunteer_id;
        $mdrtb_code=request()->mdrtb_code;
        $mdrtb_year=request()->mdrtb_year;
        $mdrtb_monopoly=request()->mdrtb_monopoly;
        $patient_township_id=request()->patient_township_id;
        $township_id=request()->township_id;
        
        $model =\App\Models\Patient::where("township_id",$patient_township_id)
                                    ->where("mdrtb_reg_no",$mdrtb_code)
                                    ->where("mdrtb_reg_year",$mdrtb_year)
                                    ->where("mdrtb_monopoly",$mdrtb_monopoly)
                                   ->first();
                                   
        //   ->whereHas("dots_patient", function ($query) use ($volunteer_id) {
        //                                 $query->where(function ($query) use ($volunteer_id){
        //                                     $query->where("volunteer_id",$volunteer_id);
        //                                 });
        //                             })
        
        if($model)
        {
            $array=request()->all();
            $array['patient_id']=$model->id;
                               
            $result = $this->superVisionVisitService->save($array);
           
            $result = $this->superVisionVisitService->getEach("id", $result->id);
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is Saved", $result)
            );
        }else{
             return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::ValidationFailed, false, "ValidationFailed", request()->all())
            );
        }
    }
    
    public function export()
   {
        $mytime = \Carbon\Carbon::now();   
        return Excel::download(new \App\Exports\SupervisionVisitExport(request()->all()), 'SupervisionVisitExport'.$mytime->toDateTimeString().'.csv');
   }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->superVisionVisitService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Supervision Visit Activities",
                $result
            )
        );
    }
    
     public function getPowerBi()
    {
      
        $result =  $this->superVisionVisitService->getPowerBi(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Supervision Visit Activities",
                $result
            )
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->superVisionVisitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit by " . request("column"), $result)
        );
    }

    public function getUncompletedList(){
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All SuperVision Activities",
                $this->superVisionVisitService->getUncompletedList(request('ids'))
            )
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'volunteer_id'=>'required',
         //   'patient_id'=>'required',
            "date" => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->superVisionVisitService->update(request()->all());
        $result = $this->superVisionVisitService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->superVisionVisitService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is deleted", $result)
        );
    }
}
