<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;

class PresumptiveController extends Controller
{
    private $presumptiveService;

    public function __construct()
    {
        parent::__construct();
        $this->presumptiveService = new \App\Service\PA\Presumptive;
    }

    public function searchByIndexCode()
    {
        $validate_result = $this->validateData([
            "index_case_no" => "required",
            "index_case_year" => "required",

        ], request()->all());

        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->getByIndexCode(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive by Index Code", $result)
        );
    }

    public function familymember_export()
    {
        $mytime = \Carbon\Carbon::now(); 
        return Excel::download(new \App\Exports\FamilyMemberExport(request()->all()), 'FamilyMemberExport_'.$mytime->toDateTimeString().'.csv');
    }


    public function get()
    {
        $result = $this->presumptiveService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive List", $result)
        );
    }

    public function getReferList()
    {
        $result = $this->presumptiveService->getReferList(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive List", $result)
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive by " . request("column"), $result)
        );
    }
    
    public function export(Request $request)
   {
      
       $mytime = \Carbon\Carbon::now();;      
        return Excel::download(new \App\Exports\PresumptiveExport($request), 'PresumptiveExport_'.$mytime->toDateTimeString().'.csv');
   }
   
   
   public function getPowerBiData(Request $request)
   {
        $model = new \App\Service\DA\PresumptiveDiagnosis;
        $presumptives = $model->getExcelExportData($request->all());
       return response()->json(
           $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptives data PowerBi", $presumptives)
       );
      
   }
}
