<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class PatientController extends Controller
{
    private $patientService;

    public function __construct()
    {
        parent::__construct();
        $this->patientService = new \App\Service\PA\Patient;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'dob' => 'required',
            'address' => 'required',
            'pre_enroll' => 'required',


        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->save(request()->all());
        $result = $this->patientService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is Saved", $result)
        );
    }



    public function get()
    {
        $result =  $this->patientService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients",
                $result
            )
        );
    }
    
    public function export(){
       $result =  $this->patientService->getAll(request()->all(),true);
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients exported list",
                $result
            )
        );
    }
    
     public function getPowerBIData(){
        $model = new \App\Service\PA\Patient;
       $result =  $this->patientService->getPowerBiData(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "Patients data PowerBi",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient by " . request("column"), $result));
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'dob' => 'required',
            'address' => 'required',
            'pre_enroll' => 'required',
            'id'=>'required'


        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->update(request()->all());
        $result = $this->patientService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is Saved", $result)
        );
    }
    
     public function getPatientsByTownship()
    {
        $model = new \App\Models\Patient();
        $result = $model->where('township_id', request()->township_id)->get();
         return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients",
                $result
            )
        );
    }


    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->patientService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is deleted", $result)
        );
    }
    
    public function apprefer()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        $dots_patient = \App\Models\DOTSPatient::find(request()->id);
                     
         $dots_patient->app_refer_status=2;
         $dots_patient->update();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Action is taken")
        );
    }
    


}
