<?php

namespace App\Http\Controllers\PA;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;

class LoginController extends Controller
{
    private $paAuthService;

    public function __construct()
    {
        parent::__construct();
        $this->paAuthService = new \App\Service\PA\Auth;
    }

    public function login()
    {

        $validate_result = $this->validateData([
            "code" => "required",
            "password" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->paAuthService->login(request()->all());
        if (!$result) {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::LoginedFailed, false, "Login Failed")
            );
        } else {
            $tokenResult = $result->createToken('PA Access Token');
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Login Success", array(
                    "token" => $tokenResult->accessToken
                ))
            );
        }
    }

    public function getYour()
    {
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Your Information", array(
                "user" => $this->paAuthService->getYour()
            ))
        );
    }

    public function changePassword()
    {

        $validate_result = $this->validateData([
            "old_password" => "required",
            "new_password" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->paAuthService->changePassword(request()->all(), request()->user()->id);

        if ($result) {

            //   $result->OauthAcessToken()->delete();
            $tokenResult = request()->user()->createToken('PA Access Token');
            return response()->json(
                $this->custom_response->create(
                    \App\Enums\ResponseCode::Success,
                    true,
                    "Changed password successfully",
                    array(
                        "token" => $tokenResult->accessToken
                    )
                )
            );
        } else {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::ValidationFailed, false, "Unable to change password")
            );
        }
    }

    public function logout()
    {
        request()->user()->OauthAcessToken()->delete();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Logout successfully")
        );
    }
}
