<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class HomeVisitActivityController extends Controller
{
    private $homeVisitService;

    public function __construct()
    {
        parent::__construct();
        $this->homeVisitService = new \App\Service\PA\HomeVisit;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'type' => 'required',
           // 'patient_id' => 'required',
            'date' => 'required',
            'se_checklist' => 'required',
            'infection_control' => 'required',
            'modifications' => 'required',
            'month' => 'required',
            'year' => 'required',
        ], request()->all());
       
        if ($validate_result) return $this->showValidateError();

        $result = $this->homeVisitService->save(request()->all());
        $result = $this->homeVisitService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "He is Saved", $result)
        );
    }
    
     public function export()
   {
        $mytime = \Carbon\Carbon::now();   
        return Excel::download(new \App\Exports\HomeVisitExport(request()->all()), 'HomeVisitExport'.$mytime->toDateTimeString().'.csv');
   }
    
    public function checkcode()
    {
     
      $patient= new \App\Models\Patient();
      $patient=$patient->where('mdrtb_reg_no',(int)request()->mdrtb_code)
                ->where('mdrtb_reg_year',request()->mdrtb_year)
                ->where('mdrtb_monopoly',request()->monopoly)
                ->where('township_id',request()->patient_township_id)
                ->first();
                
                //   ->with(['homevisit:id,patient_id,modifications']) 
              
        if($patient)
        {   
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true ,"Valid Code",
                $patient)
            );
        }  else{
              return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::ValidationFailed, false,"Invalid Code",$patient)
            );
        }  
        
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->homeVisitService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
    }
    
     public function getPowerBi()
    {
        $result =  $this->homeVisitService->getPowerBi(request()->all());
        
        // try{
              return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
        // }catch(Exception $e){
        //     var_dump($result);
        // }
      
    }


    public function getUncompletedList()
    {
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $this->homeVisitService->getUncompletedList(request('ids'))
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->homeVisitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'type' => 'required',
       //     'patient_id' => 'required',
            'date' => 'required',
            'se_checklist' => 'required',
            'infection_control' => 'required',
            'month' => 'required',
            'year' => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->homeVisitService->update(request()->all());
        $result = $this->homeVisitService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->homeVisitService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is deleted", $result)
        );
    }
}
