<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class HeActivityController extends Controller
{
    private $heService;

    public function __construct()
    {
        parent::__construct();
        $this->heService = new \App\Service\PA\He;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'type' => 'required',
            'screening_person' => 'required',
            'date' => 'required',
            'place' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->heService->save(request()->all());
        $result = $this->heService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "He is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->heService->getAll(request()->all());
       
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
    }
    
    public function export()
   {
        // $result =  $this->heService->getAll(request()->all());
           
        // return response()->json(
        //   request()->all()
        // );
       
        $mytime = \Carbon\Carbon::now();   
        return Excel::download(new \App\Exports\HEActivityExport(request()->all()), 'HEActivityExport'.$mytime->toDateTimeString().'.csv');
   }
    
     public function getPowerBi()
    {
       
        $result =  $this->heService->getPowerBi(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
    }


    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->heService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE by " . request("column"), $result)
        );
    }

    public function getUncompletedList(){
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $this->homeVisitService->getUncompletedList(request('ids'))
            )
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
             'screening_person' => 'required',
            'type' => 'required',
            'date' => 'required',
            'place' => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->heService->update(request()->all());
        $result = $this->heService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->heService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is deleted", $result)
        );
    }
}
