<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class FamilyMemberController extends Controller
{
    private $familyMemberService;

    public function __construct()
    {
        parent::__construct();
        $this->familyMemberService = new \App\Service\PA\FamilyMember;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'patient_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->save(request()->all());
        $result = $this->familyMemberService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member by patient ID " . request("patient_id"), $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->update(request()->all());
        $result = $this->familyMemberService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->familyMemberService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member is deleted", $result)
        );
    }
}
