<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class DelagatedPersonController extends Controller
{
    private $delagatedPersonService;

    public function __construct()
    {
        parent::__construct();
        $this->delagatedPersonService = new \App\Service\PA\DelagatedPerson;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'relationship' => 'required',
            'patient_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->delagatedPersonService->save(request()->all());
        $result = $this->delagatedPersonService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Delagated Person is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->delagatedPersonService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Delagated Person by patient ID " . request("patient_id"), $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->delagatedPersonService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Delagated Person by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'relationship' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->delagatedPersonService->update(request()->all());
        $result = $this->delagatedPersonService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Delagated Person is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->delagatedPersonService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Delagated Person is deleted", $result)
        );
    }
}
