<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class DOTSVisitReportController extends Controller
{
    private $dotsVisitReportService;

    public function __construct()
    {
        parent::__construct();
        $this->dotsVisitReportService = new \App\Service\PA\DOTSVisitReport;
    }


    public function get()
    {
        $validate_result = $this->validateData([
            "dots_patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->dotsVisitReportService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS Visit Report",
                $result
            )
        );
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'dots_patient_id' => 'required',
            'month' => 'required',
            'year' => 'required',
            'status' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        $result = $this->dotsVisitReportService->save(request()->all());
        $result = $this->dotsVisitReportService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Visit Report is saved", $result)        );
    }

  

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->dotsVisitReportService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Visit Report is deleted", $result)
        );
    }
}
