<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class DOTSPatientController extends Controller
{
    private $dotsPatientService;

    public function __construct()
    {
        parent::__construct();
        $this->dotsPatientService = new \App\Service\PA\DOTSPatient;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'patient_id' => 'required',
            'volunteer_id' => 'required',
            'phone' => 'required',
            'body_weight' => 'required',
            'dots_startdate' => 'required',
            'dots_app_status' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsPatientService->save(request()->all());
        $result = $this->dotsPatientService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Patient is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->dotsPatientService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS Patient Activities",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsPatientService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Patient by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'phone' => 'required',
            'body_weight' => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsPatientService->update(request()->all());
        $result = $this->dotsPatientService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Patient is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->dotsPatientService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Patient is deleted", $result)
        );
    }

    public function finishVisitDate()
    {
        $validate_result = $this->validateData([
            "dots_patient_id" => "required",
            "date" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->dotsPatientService->finishVisitDate();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Acitity is finished", $result)
        );
    }

    public function getVisitDate()
    {
        $result =  $this->dotsPatientService->getVisitDate(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS Patient Visit Dates",
                $result
            )
        );
    }
    
    public function export(Request $request)
      {
            $mytime = \Carbon\Carbon::now();
            return Excel::download(new \App\Exports\DOTSPatientExport($request), 'DOTSPatientExport'.$mytime->toDateTimeString().'.csv');
       }
}
