<?php

namespace App\Http\Controllers\PA;

use App\Http\Controllers\Controller;

class CounselingActivityController extends Controller
{
    private $counselingService;

    public function __construct()
    {
        parent::__construct();
        $this->counselingService = new \App\Service\PA\Couseling;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'date' => 'required',
         //   'patient_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        // Validation 
        $volunteer_id=request()->volunteer_id;
        $mdrtb_code=request()->mdrtb_code;
        $mdrtb_year=request()->mdrtb_year;
        $mdrtb_monopoly=request()->mdrtb_monopoly;
        
        // request()->user()->township_id
        
        $model =\App\Models\Patient::where("township_id",request()->patient_township_id)
                                    ->where("mdrtb_reg_no",$mdrtb_code)
                                    ->where("mdrtb_reg_year",$mdrtb_year)
                                    ->where("mdrtb_monopoly",$mdrtb_monopoly)
                                    ->first();

        if($model)
        {
            $array=request()->all();
            $array['patient_id']=$model->id;
                               
            $result = $this->counselingService->save($array);
            $result = $this->counselingService->getEach("id", $result->id);
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling is Saved", $result)
            );
        }else{
             return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::ValidationFailed, false, "ValidationFailed", request()->all())
            );
        }
       
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->counselingService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Counseling Activities",
                $result
            )
        );
    }
    
      public function getPowerBi()
    {
       
        $result =  $this->counselingService->getPowerBi(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Counseling Activities",
                $result
            )
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->counselingService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling by " . request("column"), $result)
        );
    }

    public function getUncompletedList(){
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Counseling Activities",
                $this->counselingService->getUncompletedList(request('ids')),
            )
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'date' => 'required',
       //     'patient_id' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->counselingService->update(request()->all());
        $result = $this->counselingService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->counselingService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling is deleted", $result)
        );
    }
}
