<?php

namespace App\Http\Controllers\EnrollApp;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use App\Models\EnrollSupport;

use Illuminate\Support\Facades\DB;

class LoginController extends Controller
{
    private $paAuthService;

    public function __construct()
    {
        parent::__construct();
        $this->paAuthService = new \App\Service\PA\Auth;
    }

    public function login()
    {

        $validate_result = $this->validateData([
            "code" => "required",
            "password" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->paAuthService->login(request()->all());
        if (!$result) {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::LoginedFailed, false, "Login Failed")
            );
        } else {
            $tokenResult = $result->createToken('PA Access Token');
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Login Success", array(
                    "token" => $tokenResult->accessToken
                ))
            );
        }
    }
    
    
     public function sync(Request $request)
    {
        $request = collect([
            'patient_id0'=>999999,
            'nominated0'=>2,
            'support_month0'=>5,
            'support_year0'=>2024,
            'nominated_month0'=>5,
            'nominated_year0'=>2024,
            'status0'=>1,
            'date0'=>'2024-05-22',
            'type0'=>2,
            'support0'=>2,
            
            "patient_id1"=> 999999,
            "nominated1" => 2,
            "support_month1" => 6,
            "support_year1" => 2024,
            "nominated_year1" => 2024,
            "nominated_month1"=>6,
            "status1" => 2,
            "date1" => '2024-06-12',
            "type1"=>2,
            "support1"=>2,
            
            "patient_id2"=> 999999,
            "nominated2" => 2,
            "support_month2" => 7,
            "support_year2" => 2024,
            "nominated_year2" => 2024,
            "nominated_month2"=>7,
            "status2" => 2,
            "date2" => '2024-07-22',
            "type2"=>2,
            "support2"=>2,
            
             "patient_id2"=> 999999,
            "nominated2" => 2,
            "support_month2" => 8,
            "support_year2" => 2024,
            "nominated_year2" => 2024,
            "nominated_month2"=>8,
            "status2" => 2,
            "date2" => '2024-08-22',
            "type2"=>2,
            "support2"=>2,
            ]); 
      
        DB::beginTransaction();
        try {
           
          // $number = (int)$request->get('number');
         
            for($i=0;$i< count($request)/10;$i++)
            {
                $enroll = new EnrollSupport();

                $patient_id=$request->get('patient_id' . $i) === 'null' ? null : $request->get('patient_id' . $i);
                $nominated = $request->get('nominated' . $i) === 'null' ? null : $request->get('nominated' . $i);
                $support_month=$request->get('support_month' .$i)==='null'?null:$request->get('support_month' .$i);
                $support_year=$request->get('support_year' .$i)==='null'?null:$request->get('support_year' .$i);
                $nominated_month=$request->get('nominated_month' .$i)==='null'?null:$request->get('nominated_month' .$i);
                $nominated_year=$request->get('nominated_year' .$i)==='null'?null:$request->get('nominated_year' .$i);
                $status = $request->get('status' . $i) === 'null' ? null : $request->get('status' . $i);
                $date=$request->get('date' .$i)==='null'?null:$request->get('date' .$i);
                $type=$request->get('type' .$i)==='null'?null:$request->get('type' .$i);
                $support=$request->get('support' .$i)==='null'?null:$request->get('support' .$i);

                $model = \App\Models\EnrollSupport::where([
                            "date" =>$date,
                            "patient_id" => $patient_id,
                            "support_month" => $support_month,
                            "support_year" => $support_year,
                        ])->first();

                //insert data to enroll
                $enroll->nominated=$nominated;
                $enroll->support_month=$support_month;
                $enroll->support_year=$support_year;
                $enroll->nominated_month=$nominated_month;
                $enroll->nominated_year=$nominated_year;
                $enroll->status=$status;
                $enroll->date=$date;
                $enroll->type=$type;
                $enroll->support=$support;
                
                //check validation for enroll
                $errorResponse=$this->checkError($enroll);
                
                if($errorResponse["success"] == true)
                {
                    if ($model) {
                        $enroll->update();
                    } else {
                        $enroll->patient_id=$patient_id;
                        $enroll->save();
                    }
                }else{
                    return response()->json(
                            ["message" => $errorResponse["message"]]
                        );
                }
                
                
            }
            DB::commit();
            return response()->json(["message" => "success"]);

        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(
                ["message" => $e->getMessage()]
            );
        }
    }
    
     public function checkError($request)
    {
        $patient = \App\Models\Patient::where("id", $request->patient_id)->first();
        $yesCount = \App\Models\EnrollSupport::where([
            "support_month" => $request->support_month,
            "support_year" => $request->support_year,
            "patient_id" => $request->patient_id,
            "status" => 1,
            "support" => 2,
        ])->count();
        
        $treatment_startdate=isset($patient->treatment_startdate)?$patient->treatment_startdate:null;
        $finished_date=isset($patient->finished_date)?$patient->finished_date:null;
        
        if ($yesCount > 0)
            return [
                "success" => false,
                "message" => "Support have been for this month"
            ];


        $date1 = '2024-08-23';
        $date2 = strtotime($request->support_year . "-" . $request->support_month . "-31");
        if ($date2 < $date1) {
            return [
                "success" => false,
                "message" => "Support month and year should be larger than treatment startdate (" . $treatment_startdate . ")"
            ];
        }

        if (request("support") == 2) {

            $date1 = strtotime($treatment_startdate);
            $date2 = strtotime($request->date);
            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than treatment startdate (" . $treatment_startdate . ")"
                ];
            }

            $date1 = strtotime($request->support_year . "-" . $request->support_month. "-01");
            $date2 = strtotime($request->date);

            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than support month and year"
                ];
            }
        }

        if (request("support") == 2) {
            $yesCount = $this->model->where([
                "patient_id" => $request->patient_id,
                "status" => 1,
                "support" => 2,
                "date" => $request->date,
            ])->first();

            if ($yesCount) {
                if ($yesCount->type != $request->type) {
                    return [
                        "success" => false,
                        "message" => "Same payment channel should be used"
                    ];
                }
            }
        }


        if ($finished_date) {
            $date1 = strtotime($finished_date);
            $date2 = strtotime($request->support_year . "-" .$request->support_month . "-01");
            if ($date2 > $date1) {
                return [
                    "success" => false,
                    "message" => "Date should not be greater than Finished Date "
                ];
            }
        }

        $lastSupport=\App\Models\EnrollSupport::where(["patient_id" => $request->patient_id, "status" => 1])->orderBy("date", "desc")->orderBy("created_at", "desc")->first();

        return [
            "success" => true
        ];
    }
    
    public function sync_test(Request $request)
    {
        $datas=[
            [
                "patient_id1"=> 999999,
                "nominated1" => 2,
                "support_month1" => 6,
                "support_year1" => 2024,
                "nominated_year1" => 2024,
                "nominated_month1"=>6,
                "status1" => 2,
                "date1" => '2024-06-22',
                "type1"=>1,
                "support1"=>2,
            ],
            [ "patient_id2"=> 999999,
                "nominated2" => 2,
                "support_month2" => 7,
                "support_year2" => 2024,
                "nominated_year2" => 2024,
                "nominated_month2"=>7,
                "status2" => 2,
                "date2" => '2024-07-22',
                "type2"=>2,
                "support2"=>2,
            ],
            [
                "patient_id3"=> 888888,
                "nominated3" => 2,
                "support_month3" => 6,
                "support_year3" => 2024,
                "nominated_year3" => 2024,
                "nominated_month3"=>6,
                "status3" => 2,
                "date3" => '2024-05-02',
                "type3"=>1,
                "support3"=>2,
            ],
        ];
        
        $insertedData = [];
        
       for($i=0;$i<count($datas);$i++)
       {
          $field=$datas[$i];
          
              $model = \App\Models\EnrollSupport::where([
               "date" => $field["date".(string)($i+1)],
                "patient_id" => $field["patient_id".(string)($i+1)],
               "support_month" => $field["support_month".(string)($i+1)],
                "support_year" => $field["support_year".(string)($i+1)],
            ])->first();
       
             $insertedData = [
                "nominated" => $field["nominated".(string)($i+1)],
                "support_month" => $field["support_month".(string)($i+1)],
                "support_year" => $field["support_year".(string)($i+1)],
                "nominated_year" => $field["nominated_year".(string)($i+1)],
                "nominated_month" => $field["nominated_month".(string)($i+1)],
                "status" => $field["status".(string)($i+1)],
                "date" => $field["date".(string)($i+1)],
                "type"=>$field["type".(string)($i+1)],
                "support"=>$field["support".(string)($i+1)],
                ];
          
           $model = \App\Models\EnrollSupport::create($insertedData);
          
       }
    
        if ($item["nominated"] == 2 && $item["support"] == 2) {
            $insertedData["support"] = $item["support"];
            $insertedData["type"] = $item["type"];
            
            //   if ($insertedData["type"] == 1) {
            //         $signature = FileService::save($item["signature"], "patients/enrolls/supports");
            //         $insertedData["signature"] = $signature;
            //     }
                
            if ($insertedData["type"] == 1)  {

                $base64Image = $item["signature"];

                $data = substr($base64Image, strpos($base64Image, ',') + 1);

                // Convert Base64 to binary data
                $imageData = base64_decode($data);

                $imageName = uniqid() . '.png';

                // Save the image
                
                file_put_contents(storage_path('app/public/patients/enrolls/supports' . $imageName), $imageData);
                
                $insertedData["signature"] = $imageName;

            }
            
            // if (!is_null($item["signature"]) && $item["signature"] != "null" && $insertedData["type"] == 1) {
            //     $insertedData["signature"] = $item["signature"];
            // } 
            
            if ($insertedData["type"] != 1) {
                    $insertedData["signature"] = null;
                }

        }
        
        if ($model) {
            $model->update($insertedData);
        } else {
            $insertedData["patient_id"] = $item["patient_id"];
            $model = \App\Models\EnrollSupport::create($insertedData);
        }
      
    }

    public function getYour()
    {
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Your Information", array(
                "user" => $this->paAuthService->getYour()
            ))
        );
    }

    public function logout()
    {
        request()->user()->OauthAcessToken()->delete();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Logout successfully")
        );
    }
}
