<?php

namespace App\Http\Controllers\EnrollApp;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Service\EnrollApp\EnrollPatient;
// use App\Service\EnrollApp\EnrollSupport;
// use App\Service\EnrollApp\PreEnrollSupport;
use App\Models\EnrollSupport;
use App\Models\PreEnrollSupport;
use App\Services\FileUploadService;

use App\Enums\ResponseCode;

class EnrollPatientController extends Controller
{
    private $enrollPatients;

    public function __construct(EnrollPatient $enrollPatients, EnrollSupport $enrollSupportService, PreEnrollSupport $preEnrollSupportService)
    {
        
        parent::__construct();
        $this->enrollPatients = $enrollPatients;
        //$this->enrollSupportService = $enrollSupportService;
        //$this->preEnrollSupportService = $preEnrollSupportService;
    }

    //   public function sync(Request $request)
    //     {
       
    //     return DB::transaction(function () use ($request) {
           
    
    //         $enrollSupports =  $request->input("enroll_supports");
    //         $preEnrollSupports =  $request->input("pre_enroll_supports");
           
    //         try {
                
    //             // if($enrollSupports != []){
    //             //     $errorResponse =$this->enrollSupportService->checkError(request()->all);
    //             //     if ($errorResponse["success"] == true) 
    //             //     {
    //             //          $this->enrollSupportService->save($enrollSupports);
    //             //     }
                  
    //             // }
                
    //             // if($preEnrollSupports != []){
    //             //     $errorResponse = $this->preEnrollSupportService->checkError(request()->all);
    //             //     if ($errorResponse["success"] == true)
    //             //     {
    //             //         $this->preEnrollSupportService->save($preEnrollSupports);
    //             //     }
                    
    
    //             // }
               
    //             $patients = $this->enrollPatients->getAll();
                
               
    //             if ($request->hasFile('signature')) {
                    
    //                 $file = $request->file('signature');
    //                 $filename = $file->getClientOriginalName();
    //                 $filesize = $file->getSize();
            
    //             }else{
    //                 $file = 'not found';
    //             }
                    
                // return response()->json(
                //     $this->custom_response->create(ResponseCode::Success, true, "Patients", [
                //         "patients" => $patients,
                //         "requests" => $request->all(),
                //         "file" => $file
                //     ])
                // );
    //         } catch (Exception $e) {
    //             return response()->json($e);
    //         }
    //     });
    // }

    public function sync(Request $request)
    {
        DB::beginTransaction();
        
        try {
            //get patients data
           $patients = $this->enrollPatients->getAll();
           
           $number = (int)$request->get('number');
         
            for($i=0;$i< $number;$i++)
            
            {
                $enroll = new EnrollSupport();

                $patient_id=$request->get('patient_id' . $i) === 'null' ? null : $request->get('patient_id' . $i);
                $nominated = $request->get('nominated' . $i) === 'null' ? null : $request->get('nominated' . $i);
                $support_month=$request->get('support_month' .$i)==='null'?null:$request->get('support_month' .$i);
                $support_year=$request->get('support_year' .$i)==='null'?null:$request->get('support_year' .$i);
                $nominated_month=$request->get('nominated_month' .$i)==='null'?null:$request->get('nominated_month' .$i);
                $nominated_year=$request->get('nominated_year' .$i)==='null'?null:$request->get('nominated_year' .$i);
                $status = $request->get('status' . $i) === 'null' ? 0 : $request->get('status' . $i);
                $date=$request->get('date' .$i)==='null'?null:$request->get('date' .$i);
                $type=$request->get('type' .$i)==='null'?null:$request->get('type' .$i);
                $support=$request->get('support' .$i)==='null'?null:$request->get('support' .$i);
                    
                $model = \App\Models\EnrollSupport::where([
                            "date" =>$date,
                            "patient_id" => $patient_id,
                            "support_month" => $support_month,
                            "support_year" => $support_year,
                        ])->first();
                        
                 //insert data to enroll
                $enroll->nominated=$nominated;
                $enroll->support_month=$support_month;
                $enroll->support_year=$support_year;
                $enroll->nominated_month=$nominated_month;
                $enroll->nominated_year=$nominated_year;
                $enroll->status=$status;
                $enroll->date=$date;
                $enroll->type=$type;
                $enroll->support=$support;
                $enroll->sync_status=0;
                
                //pre_enroll data
                $pre_patient_id=$request->get('pre_patient_id' . $i) === 'null' ? null : $request->get('pre_patient_id' . $i);
                $pre_nominated = $request->get('pre_nominated' . $i) === 'null' ? null : $request->get('pre_nominated' . $i);
                $pre_support_month=$request->get('pre_support_month' .$i)==='null'?null:$request->get('pre_support_month' .$i);
                $pre_support_year=$request->get('pre_support_year' .$i)==='null'?null:$request->get('pre_support_year' .$i);
                $pre_nominated_month=$request->get('pre_nominated_month' .$i)==='null'?null:$request->get('pre_nominated_month' .$i);
                $pre_nominated_year=$request->get('pre_nominated_year' .$i)==='null'?null:$request->get('pre_nominated_year' .$i);
                $pre_status = $request->get('pre_status' . $i) === 'null' ? 0 : $request->get('pre_status' . $i);
                $pre_date=$request->get('pre_date' .$i)==='null'?null:$request->get('pre_date' .$i);
                $pre_type=$request->get('pre_type' .$i)==='null'?null:$request->get('pre_type' .$i);
                $pre_support=$request->get('pre_support' .$i)==='null'?null:$request->get('pre_support' .$i);
                $pre_month_type=$request->get('pre_monthType' .$i)==='null'?null:$request->get('pre_monthType' .$i);;
                    
               
                $pre_model = \App\Models\PreEnrollSupport::where([
                            "date" =>$pre_date,
                            "patient_id" => $pre_patient_id,
                            "support_month" => $pre_support_month,
                            "support_year" => $pre_support_year,
                        ])->first();
                        
                //insert data to pre enroll
                $preenroll = new PreEnrollSupport();
                $preenroll->nominated=$pre_nominated;
                $preenroll->support_month=$pre_support_month;
                $preenroll->support_year=$pre_support_year;
                $preenroll->nominated_month=$pre_nominated_month;
                $preenroll->nominated_year=$pre_nominated_year;
                $preenroll->status=$pre_status;
                $preenroll->date=$pre_date;
                $preenroll->type=$pre_type;
                $preenroll->support=$pre_support;
                $preenroll->sync_status=0;
                $preenroll->month_type=$pre_month_type;
                        
                
                 if ($type == 1)  
                 {
                     if ($request->hasFile('signature'.$i)) {
                            $file = $request->file('signature'.$i);
                            $filename = $file->getClientOriginalName();
                            $file->storeAs('public/patients/enrolls/supports/',$filename);
                            
                            $enroll->signature=$filename;  
                        
                        }else{
                             return response()->json(
                                    $this->custom_response->create(ResponseCode::Success, false, "Patients", [
                                        "patients" => $patients,
                                        "message" =>$request->hasFile('signature'.$i),
                                    ])
                                );
                        }
                 }else{
                      $enroll->signature=null;    
                 }

                 if ($pre_type == 1)  
                 {
                     if ($request->hasFile('signature'.$i)) {
                            $pre_file = $request->file('signature'.$i);
                            $pre_filename = $pre_file->getClientOriginalName();
                            $pre_file->storeAs('public/patients/pre_enrolls/supports/',$pre_filename);
                            
                            $preenroll->signature=$pre_filename;  
                        
                        }else{
                             return response()->json(
                                    $this->custom_response->create(ResponseCode::Success, false, "Patients", [
                                        "patients" => $patients,
                                        "message" =>$request->hasFile('signature'.$i),
                                    ])
                                );
                        }
                 }else{
                      $preenroll->signature=null;    
                 }

                //check validation for enroll
                if($support!=null)
                {
                    $errorResponse=$this->checkError($enroll);
                    if($errorResponse["success"]== true)
                    {
                        if ($model) {
                            $enroll->update();
                        } else {
                            $enroll->patient_id=$patient_id;
                            $enroll->save();
                        }
                    }else{
                         DB::rollBack();
                         return response()->json(
                            $this->custom_response->create(ResponseCode::Success, false, "Patients", [
                                "patients" => $patients,
                                "message" => $errorResponse["message"],
                            ])
                        );
                    }
                }
               
                if($pre_support!=null)
                {
                    //$pre_errorResponse=$this->checkError($preenroll);
                    $pre_errorResponse=true;
                    // $pre_errorResponse["success"] == true;
                    if($pre_errorResponse==true)
                    {
                        if ($pre_model) {
                            $preenroll->update();
                        } else {
                            $preenroll->patient_id=$pre_patient_id;
                            $preenroll->save();
                        }
                    }else{
                         DB::rollBack();
                         return response()->json(
                            $this->custom_response->create(ResponseCode::Success, false, "Patients", [
                                "patients" => $patients,
                                "message" => $pre_errorResponse["message"],
                            ])
                        );
                    }
                }
                
                
            }
            //send response
            DB::commit();
            return response()->json(
                $this->custom_response->create(ResponseCode::Success, true, "Patients", [
                    "patients" => $patients,
                    "message" => 'success',
                    "requests" => $request->all(),
                ])
            );

        } catch (Exception $e) {
            DB::rollBack();
            
                return response()->json(
                $this->custom_response->create(ResponseCode::Success, false, "Patients", [
                    "patients" => $patients,
                    "requests" => $request->all(),
                    "message" => $e->getMessage(),
                ])
            );
        }
    }
    
    public function checkError($request)
    {
        $patient = \App\Models\Patient::where("id", $request->patient_id)->first();
        $yesCount = \App\Models\EnrollSupport::where([
            "support_month" => $request->support_month,
            "support_year" => $request->support_year,
            "patient_id" => $request->patient_id,
            "status" => 1,
            "support" => 2,
        ])->count();
        
        $treatment_startdate=isset($patient->treatment_startdate)?$patient->treatment_startdate:null;
        $finished_date=isset($patient->finished_date)?$patient->finished_date:null;
        
        if ($yesCount > 0)
            return [
                "success" => false,
                "message" => "Support have been for this month"
            ];


        $date1 = strtotime($treatment_startdate);
        $date2 = strtotime($request->support_year . "-" . $request->support_month . "-31");
        if ($date2 < $date1) {
            return [
                "success" => false,
                "message" => "Support month and year should be larger than treatment startdate (" . $treatment_startdate . ")"
            ];
        }

        if (request("support") == 2) {

            $date1 = strtotime($treatment_startdate);
            $date2 = strtotime($request->date);
            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than treatment startdate (" . $treatment_startdate . ")"
                ];
            }

            $date1 = strtotime($request->support_year . "-" . $request->support_month. "-01");
            $date2 = strtotime($request->date);

            if ($date2 < $date1) {
                return [
                    "success" => false,
                    "message" => "Support date should be larger than support month and year"
                ];
            }
        }

        if (request("support") == 2) {
            $yesCount = $this->model->where([
                "patient_id" => $request->patient_id,
                "status" => 1,
                "support" => 2,
                "date" => $request->date,
            ])->first();

            if ($yesCount) {
                if ($yesCount->type != $request->type) {
                    return [
                        "success" => false,
                        "message" => "Same payment channel should be used"
                    ];
                }
            }
        }


        if ($finished_date) {
            $date1 = strtotime($finished_date);
            $date2 = strtotime($request->support_year . "-" .$request->support_month . "-01");
            if ($date2 > $date1) {
                return [
                    "success" => false,
                    "message" => "Date should not be greater than Finished Date "
                ];
            }
        }

        $lastSupport=\App\Models\EnrollSupport::where(["patient_id" => $request->patient_id, "status" => 1])->orderBy("date", "desc")->orderBy("created_at", "desc")->first();

        return [
            "success" => true
        ];
    }

}
