<?php

namespace App\Http\Controllers\DotsApp;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;

class DotsPatientController extends Controller
{
    private $dotsPatientService;

    public function __construct()
    {
        parent::__construct();
        $this->dotsPatientService = new \App\Service\DotsApp\DotsPatient;
        $this->dotsVisitDateService = new \App\Service\DotsApp\DotsVisitDate;
    }

    public function sync()
    {
        
        DB::beginTransaction();

            try {
                
               $visitdates = json_decode(request()->visit_dates)??[];
                
                $this->dotsVisitDateService->saveAll($visitdates);
               
                $patients = $this->dotsPatientService->getAll();
                $visitDates = $this->dotsVisitDateService->getAll();
                
                DB::commit();
                  return response()->json(
                    $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Patients", [
                        "patients" => $patients,
                        "visit_dates" => $visitDates,
                       
                    ])
                );
            } catch (Exception $e) {
                DB::rollBack();
                return response()->json(["error" => $e->getMessage(), "visitDates"=> $visitDates]);
            }
    }
    
    
    public function test_sync()
    {
        
                 $visitdates = json_decode(request()->visit_dates);
                $this->dotsVisitDateService->test_saveAll($visitdates);
               
                $patients = $this->dotsPatientService->test_getAll();
                $visitDates = $this->dotsVisitDateService->test_getAll();
                
                  return response()->json(
                    $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Patients", [
                        "visit_dates" => $visitDates,
                         "patients" => $patients,
                    ])
                );
    }
    
    public function test()
    {
             $model = \App\Models\DOTSVisitDate::where("date", '2022-11-04')
                                                ->where("dots_patient_id", 96)
                                                ->with([
                                                    "dots_patient.patient",
                                                    "volunteer"
                                                    ])
                                                ->with([
                                                    "dots_patient" => function ($query) {
                                                        $query->select('id','patient_id','volunteer_id'); 
                                                    },
                                                    "dots_patient.patient" => function ($query) {
                                                        $query->select('id', 'name','township_id','mdrtb_reg_no','mdrtb_reg_year','finished_date','change_finished_date'); 
                                                    },
                                                    "volunteer" => function ($query) {
                                                        $query->select('id', 'name'); 
                                                    }
                                                ])
                   
                                               ->first();
                                               
            //get low side effect
            $code=$model->low_side_effect;
            $array = explode(',', $code);
          
            $low_side_effect = \App\Models\LowSideEffect::whereIn('id', $array)
                               ->pluck('eng_name')
                            ->toArray();
                                
            //check high side effect 3 or 4
            //  $high_side_effect= $model->high_side_effect;
            $high_side_effect='3,2';
            
             $township_id=$model->dots_patient->patient->township_id;
            
            
            $check_side_effect = Str::contains($high_side_effect,'3') || Str::contains($high_side_effect,'4')?'true':'false';
            
          
            
            if($check_side_effect=='true')
            {
                $contain_referred = Str::contains($high_side_effect,'3') ?'true':'false';
                $contain_immediate = Str::contains($high_side_effect,'4') ?'true':'false';
                 $data=[];
                    if($contain_immediate=='true')
                     {
                          $data['side_effect'] = "immediate referred";
                         
                     }elseif($contain_referred=='true')
                     {
                          $data['side_effect'] = "referred";
                     }
                     
                     $data['date'] = $model->date;
                     $data['pt_name']= $model->dots_patient->patient->name;
                     $data['vol_name']= $model->dots_patient->volunteer->name;
                     $data['low_side_effect']=implode(', ', $low_side_effect);
             
                $pas= \App\Models\PA::where("township_id",999)->select('id','mail')->first();
            
               
                
                Mail::to('thandarannie12@gmail.com')->send(new SendMail($data));
                 return "success";
                foreach ($pas as $key => $pa) {
                     return $pa->mail;
                   Mail::to($user->email)->send(new SendMail($data));
                }
            }
            
            
        }
}
