<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class VolunteerController extends Controller
{
    private $volunteerService;

    public function __construct()
    {
        parent::__construct();
        $this->volunteerService = new \App\Service\Dashboard\Volunteer;
    }

    public function get()
    {
        
        $result =  $this->volunteerService->getAll(request()->all());
      
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All volunteers",
                $result
            )
        );
    }

    public function trash()
    {
        $result =  $this->volunteerService->trash(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All volunteers from trash",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->volunteerService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer by " . request("column"), $result)
        );
    }
}
