<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

class TownshipGroupController extends Controller
{
    private $townshipGroupService;

    public function __construct()
    {
        parent::__construct();
        $this->townshipGroupService = new \App\Service\Dashboard\TownshipGroup;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->townshipGroupService->save(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township Group is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->townshipGroupService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Township groups",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->townshipGroupService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township Group by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->townshipGroupService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township Group is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->townshipGroupService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township Group is deleted", $result)
        );
    }

}
