<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class TownshipController extends Controller
{
    private $townshipService;

    public function __construct()
    {
        parent::__construct();
        $this->townshipService = new \App\Service\Dashboard\Township;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "short_code" => "required",
            "township_group_id" => "required",
            "region_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->townshipService->save(request()->all());
        $result = $this->townshipService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->townshipService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Townships",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->townshipService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township by " . request("column"), $result)
        );
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "short_code" => "required",
            "township_group_id" => "required",
            "region_id" => "required",
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->townshipService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->townshipService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township is deleted", $result)
        );
    }
}
