<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

class SymptonController extends Controller
{
    private $symptonService;

    public function __construct()
    {
        parent::__construct();
        $this->symptonService = new \App\Service\Dashboard\Sympton;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "mm_name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->symptonService->save(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Sympton is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->symptonService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Symptons",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->symptonService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Sympton by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
            "mm_name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->symptonService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Sympton is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->symptonService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Sympton is deleted", $result)
        );
    }

}
