<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class SupervisionVisitActivityController extends Controller
{
    private $superVisionVisitService;

    public function __construct()
    {
        parent::__construct();
        $this->superVisionVisitService = new \App\Service\Dashboard\SupervisionVisit;
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",

        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->superVisionVisitService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Supervision Visit Activities",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->superVisionVisitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit by " . request("column"), $result)
        );
    }

    public function checked()
    {
        $model = \App\Models\SupervisionVisitActivity::find(request("id"));
        $model->checked = request('checked');
        $model->update();
        return response()->json(["success" => true, "data" => $model]);
    }
}
