<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

class RiskFactorController extends Controller
{
    private $riskFactorService;

    public function __construct()
    {
        parent::__construct();
        $this->riskFactorService = new \App\Service\Dashboard\RiskFactor;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->riskFactorService->save(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Risk Factor is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->riskFactorService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Risk Factors",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->riskFactorService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Risk Factor by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->riskFactorService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Risk Factor is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->riskFactorService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Risk Factor is deleted", $result)
        );
    }

}
