<?php

namespace App\Http\Controllers\Dashboard;

use Maatwebsite\Excel\Facades\Excel;
use App\Http\Controllers\Controller;

class ReportController extends Controller
{
    private $form7ReportService;

    public function __construct()
    {
        parent::__construct();
        $this->form7ReportService = new \App\Service\Dashboard\FormSeven;
        $this->monthlyReportService = new \App\Service\Dashboard\MonthlyReport;
        $this->volunteerReportService = new \App\Service\Dashboard\VolunteerReport;
             $this->nominationService = new \App\Service\Dashboard\Nomination;
    }

    public function getForm7Report()
    {
        $result = $this->form7ReportService->get();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Form 7 Report", $result)
        );
    }
    public function exporForm7Report()
    {
        $result = $this->form7ReportService->get();
        Excel::download(new \App\Exports\Form7Export($result), 'FORM7EXPORT_' . '.xlsx');
    }

    public function getMonthlyReport()
    {
        $result = $this->monthlyReportService->get();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Monthly Report", $result)
        );
    }

    public function getReportedVolunteer()
    {
        $result = $this->monthlyReportService->getReportedVolunteer();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Monthly Reported Volunteer", $result)
        );
    }

    public function getDOTSReportedVolunteer()
    {
        $result = $this->monthlyReportService->getDOTSReportedVolunteer();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Monthly DOTS Reported Volunteer", $result)
        );
    }

    public function getVolunteerDetailReport()
    {
        $validate_result = $this->validateData([
            "volunteer_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->volunteerReportService->get();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Monthly DOTS Reported Volunteer", $result)
        );
    }
    
    public function getNominationList(){
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required"
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        $result = $this->nominationService->get();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Monthly Nomination List Report", $result)
        );

        
    }
    
    
     public function getNominationList14A()
     {
            
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required"
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        $result = $this->nominationService->get14A();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Pre-Enroll Pre Enroll Nomination List Report", $result)
        );

        
    }
}
