<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

class RegionController extends Controller
{
    private $regionService;

    public function __construct()
    {
        parent::__construct();
        $this->regionService = new \App\Service\Dashboard\Region;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->regionService->save(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Region is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->regionService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All regions",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->regionService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Region by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->regionService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Region is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->regionService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Region is deleted", $result)
        );
    }

}
