<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class ReferPatientController extends Controller
{
    private $referPatientService;

    public function __construct()
    {
        parent::__construct();
        $this->referPatientService = new \App\Service\Dashboard\ReferPatient;
    }

    public function get()
    {
      

        $result = $this->referPatientService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient by patient ID " . request("patient_id"), $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->referPatientService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient by " . request("column"), $result)
        );
    }
}
