<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;

class PresumptiveController extends Controller
{
    private $presumptiveService;

    public function __construct()
    {
        parent::__construct();
        $this->presumptiveService = new \App\Service\Dashboard\Presumptive;
       
    }

    public function searchByIndexCode()
    {
        $validate_result = $this->validateData([
            "index_case_no" => "required",
            "index_case_year" => "required",
            "township_id"=>"required"

        ], request()->all());

        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->getByIndexCode(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive by Index Code", $result)
        );
    }
    
    
    public function get()
    {
        $result = $this->presumptiveService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive List", $result)
        );
    }

    public function getReferList()
    {
        $result = $this->presumptiveService->getReferList(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive List", $result)
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
            
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive by " . request("column"), $result)
        );
    }
    
    public function ci_export()
    {
          $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
            "township_id" => "required",
        ], request()->all());
        
        
        $mytime = \Carbon\Carbon::now(); 
        return Excel::download(new \App\Exports\CiExport(request()->all()), 'CiExport'.$mytime->toDateTimeString().'.csv');
       
    }
}
