<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class PatientMDRTBRegimentController extends Controller
{
    private $mdrtbRegimentService;

    public function __construct()
    {
        parent::__construct();
        $this->mdrtbRegimentService = new \App\Service\Dashboard\PatientMDRTBRegiment;
    }
    
    public function get()
    {
        $validate_result = $this->validateData([
            "patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->mdrtbRegimentService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All MDRTB Regiment Activities",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->mdrtbRegimentService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "MDRTB Regiment by " . request("column"), $result)
        );
    }
}
