<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Patient;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use Carbon\Carbon;

class PatientController extends Controller
{
    private $patientService;

    public function __construct()
    {
        parent::__construct();
        $this->patientService = new \App\Service\Dashboard\Patient;
    }
    
    public function get()
    {
        $result =  $this->patientService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients",
                $result
            )
        );
    }
    
    // public function export(Request $request)
    // {
    //     $mytime = \Carbon\Carbon::now(); 
    //     return Excel::download(new \App\Exports\PatientListExport($request), 'PatientList_'.$mytime->toDateTimeString().'.csv');
    // }
    
     public function exportFinished(Request $request)
     {
         
        $mytime = \Carbon\Carbon::now(); 
        return Excel::download(new \App\Exports\OutcomeFinishedExport($request), 'FinishedDate_Export'.$mytime->toDateTimeString().'.csv');
     }
     
    public function exportIssue(Request $request)
    {
        $mytime = \Carbon\Carbon::now(); 
        return Excel::download(new \App\Exports\OutcomeIssueExport($request), 'Issue_Export'.$mytime->toDateTimeString().'.csv');
    
        // $model = new \App\Models\Patient();
        // $result = $model->whereBetween('issue_date', [request()->issue_from_date, request()->issue_to_date]);
        
        // if(request()->township_group_id==6)
        // {
        //     $result =  $result->with([
        //                             "mdrtbRegiments" => function ($query) {
        //                             $query->orderBy("created_at", "desc");
        //                         },"township"])->get();
        // }else{
        //     $result =  $result->whereHas("township",function($query){
        //         $query->where("township_group_id",request()->township_group_id);
        //         })->with([
        //             "mdrtbRegiments" => function ($query) {
        //             $query->orderBy("created_at", "desc");
        //         },"township"])->get();
        // }
              
                
        //  return response()->json(
        //     $this->custom_response->create(
        //         \App\Enums\ResponseCode::Success,
        //         true,
        //         "All patients",
        //         $result
        //     )
        // );
    }
    
     public function export()
    {
        $result =  $this->patientService->getAll(request()->all(), true);
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients exported list",
                $result
            )
        );
    }
    
    // public function familymember_export()
    // {
    //   $month=request()->month;
    //   $year=request()->year;
    //   $diagnoses=request()->diagnoses;
       
    //      $this->model=new \App\Models\Presumptive();
    //      $withColumns = [
    //         "township"=> function ($query) {
    //             $query->with("township_group");
    //         }, 
    //         "patient"=> function ($query)use ($month, $year) {
    //             $query->where('status','!=',0)
    //             ->with("enroll_supports", function ($query)use ($month, $year) {
    //                           if($month>12)
    //                           {
    //                               if($month==13)
    //                               {
    //                                   $query->where("status", 1)
    //                                   ->whereBetween('support_month', [1,6])
    //                                     ->where("support_year",$year);
    //                               }
    //                               if($month==14)
    //                               {
    //                                   $query->where("status", 1)
    //                                   ->whereBetween('support_month', [7,12])
    //                                     ->where("support_year",$year);
    //                               }
    //                           }else{
    //                               $query->where("status", 1)
    //                                     ->where("support_month",$month)
    //                                     ->where("support_year",$year);
    //                           }
                            
    //                         });
    //         },
    //         "diagonsis","cis"
    //     ];
        
    //     $this->model =$this->model->where('relationship',1)
    //                             ->where('status',1)
    //                             ->whereHas('patient',function ($query)use ($month, $year) {
    //                                     $query->where('status','!=',0)
    //                                     ->whereHas("enroll_supports", function ($query)use ($month, $year) {
    //                                                   if($month>12)
    //                                                   {
    //                                                       if($month==13)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('support_month', [1,6])
    //                                                             ->where("support_year",$year);
    //                                                       }
    //                                                       if($month==14)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('support_month', [7,12])
    //                                                             ->where("support_year",$year);
    //                                                       }
    //                                                   }else{
    //                                                       $query->where("status", 1)
    //                                                             ->where("support_month",$month)
    //                                                             ->where("support_year",$year);
    //                                                   }
                                                    
    //                                                 })
    //                                     ->with("enroll_supports", function ($query)use ($month, $year) {
    //                                                   if($month>12)
    //                                                   {
    //                                                       if($month==13)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('support_month', [1,6])
    //                                                             ->where("support_year",$year);
    //                                                       }
    //                                                       if($month==14)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('support_month', [7,12])
    //                                                             ->where("support_year",$year);
    //                                                       }
    //                                                   }else{
    //                                                       $query->where("status", 1)
    //                                                             ->where("support_month",$month)
    //                                                             ->where("support_year",$year);
    //                                                   }
                                                    
    //                                                 });
    //                                 })
    //                             ->with($withColumns)
    //                             ->orderBy("created_at", "desc");
         
    //     $familymembers= $this->model->get();
        
    //     foreach($familymembers as $fam)
    //     {
    //          $count=0;
    //          $diagnosis=0;
             
    //         if($fam->diagonsis->count() > 0)
    //         {
    //             $diagnosis=1;
    //             foreach($fam->diagonsis as $dia)
    //             {
    //                 //$dia=$dia->whereYear('register_date',$year);
    //                 $carbonDate = Carbon::parse($dia->register_date);

    //                 $reg_month = $carbonDate->month; 
    //                 $reg_year=$carbonDate->year;
                   
    //                 if($reg_year==$year)
    //                 {
    //                      if($month>12)
    //                      {
    //                          if($month==13)
    //                          {
    //                              if($reg_month>=1 && $reg_month<=6)
    //                              {
    //                                   $count++;
    //                              }
    //                          }
    //                          elseif($month==14)
    //                          {
    //                              if($reg_month>=7 && $reg_month<=12)
    //                              {
    //                                   $count++;
    //                              }
    //                          }
    //                      }else{
    //                         if($month==$reg_month)
    //                         {
    //                             $count++;
    //                         }
    //                      }
    //                 }
                   
    //             }
    //         }else{
    //             $count=0;
    //             $diagnosis=0;
    //         }
            
    //         //Cis
    //         $symptom_screening=0;
    //         $cis = $fam->cis;
            
           
           
    //         $cisCount = count($cis);
    //       for ($i = 0; $i < $cisCount; $i++) {
    //             $ci = $cis[$i];
                
              
    //             if((int)$ci->symptom_screening==2 || $ci->symptom_screening=='2')
    //             {
    //                 $date = Carbon::parse($ci->date); 
    //                 $ci_month = $date->month;
    //                 $ci_year = $date->year;
                   
    //                  if($ci_year==$year){
    //                     if($month==13)
    //                      {
    //                          if($ci_month==1||$ci_month==2||$ci_month==3||$ci_month==4||$ci_month==5||$ci_month==6)
    //                          {
    //                               $symptom_screening+=1;
    //                          }
    //                      }
    //                      if($month==14)
    //                      {
    //                          if($ci_month==7||$ci_month==8||$ci_month==9||$ci_month==10||$ci_month==11||$ci_month==12)
    //                          {
    //                               $symptom_screening+=1;
    //                          }
    //                      }
    //                       if($ci_month==$month)
    //                          {
    //                              $symptom_screening+=1;
    //                          }
    //                   }
                    
                   
    //             }else{
    //                 $symptom_screening=0;
    //             }
    //         }
    //         $fam['sym_screening']=$symptom_screening;
            
    //         $fam['reg_date']=$count;
    //         $fam['diag']=$diagnosis;
            
             
           
    //     }
        
    //     return $familymembers->toArray();
    // }
    
    public function familymember_export()
    {
        $mytime = \Carbon\Carbon::now(); 
        return Excel::download(new \App\Exports\FamilyMemberExport(request()->all()), 'FamilyMemberExport_'.$mytime->toDateTimeString().'.csv');
        
    }
    
    // public function familymember_export()
    // {
    //   $month=request()->month;
    //   $year=request()->year;
    //   $diagnoses=request()->diagnoses;
       
    //      $this->model=new \App\Models\Presumptive();
    //      $withColumns = [
    //         "township"=> function ($query) {
    //             $query->with("township_group");
    //         }, 
    //         "patient"=> function ($query)use ($month, $year) {
    //             $query->where('status','!=',0)
    //             ->with("enroll_supports", function ($query)use ($month, $year) {
    //                           if($month>12)
    //                           {
    //                               if($month==13)
    //                               {
    //                                   $query->where("status", 1)
    //                                   ->whereBetween('nominated_month', [1,6])
    //                                     ->where("nominated_year",$year);
    //                               }
    //                               if($month==14)
    //                               {
    //                                   $query->where("status", 1)
    //                                   ->whereBetween('nominated_month', [7,12])
    //                                     ->where("nominated_year",$year);
    //                               }
    //                           }else{
    //                               $query->where("status", 1)
    //                                     ->where("nominated_month",$month)
    //                                     ->where("nominated_year",$year);
    //                           }
                            
    //                         });
    //         },
    //         "diagonsis","cis"
    //     ];
        
    //     $this->model =$this->model->where('relationship',1)
    //                             ->where('status',1)
    //                             ->whereHas('patient',function ($query)use ($month, $year) {
    //                                     $query->where('status','!=',0)
    //                                     ->whereHas("enroll_supports", function ($query)use ($month, $year) {
    //                                                   if($month>12)
    //                                                   {
    //                                                       if($month==13)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('nominated_month', [1,6])
    //                                                             ->where("nominated_year",$year);
    //                                                       }
    //                                                       if($month==14)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('nominated_month', [7,12])
    //                                                             ->where("nominated_year",$year);
    //                                                       }
    //                                                   }else{
    //                                                       $query->where("status", 1)
    //                                                             ->where("nominated_month",$month)
    //                                                             ->where("nominated_year",$year);
    //                                                   }
                                                    
    //                                                 })
    //                                     ->with("enroll_supports", function ($query)use ($month, $year) {
    //                                                   if($month>12)
    //                                                   {
    //                                                       if($month==13)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('nominated_month', [1,6])
    //                                                             ->where("nominated_year",$year);
    //                                                       }
    //                                                       if($month==14)
    //                                                       {
    //                                                           $query->where("status", 1)
    //                                                           ->whereBetween('nominated_month', [7,12])
    //                                                             ->where("nominated_year",$year);
    //                                                       }
    //                                                   }else{
    //                                                       $query->where("status", 1)
    //                                                             ->where("nominated_month",$month)
    //                                                             ->where("nominated_year",$year);
    //                                                   }
                                                    
    //                                                 });
    //                                 })
    //                             ->with($withColumns)
    //                             ->orderBy("created_at", "desc");
         
    //     $familymembers= $this->model->get();
       
    //     foreach($familymembers as $fam)
    //     {
    //          $count=0;
    //          $diagnosis=0;
             
    //         if($fam->diagonsis->count() > 0)
    //         {
    //             $diagnosis=1;
    //             foreach($fam->diagonsis as $dia)
    //             {
    //                 //$dia=$dia->whereYear('register_date',$year);
    //                 $carbonDate = Carbon::parse($dia->register_date);

    //                 $reg_month = $carbonDate->month; 
                    
    //                 $reg_year=$carbonDate->year; 
                    
    //                 if($reg_year==$year)
    //                 {
    //                      if($month>12)
    //                      {
    //                          if($month==13)
    //                          {
    //                              if($reg_month>=1 && $reg_month<=6)
    //                              {
    //                                   $count++;
    //                              }
    //                          }
    //                          elseif($month==14)
    //                          {
    //                              if($reg_month>=7 && $reg_month<=12)
    //                              {
    //                                   $count++;
    //                              }
    //                          }
    //                      }else{
    //                         if($month==$reg_month)
    //                         {
    //                             $count++;
    //                         }
    //                      }
    //                 }
                   
    //             }
    //         }else{
    //             $count=0;
    //             $diagnosis=0;
    //         }
            
    //          //Cis
    //         $symptom_screening=0;
    //         $cis = $fam->cis;
    //         $symptom_screening_arr=[];
            
           
           
    //         $cisCount = count($cis);
    //       for ($i = 0; $i < $cisCount; $i++) {
    //             $ci = $cis[$i];
                
              
    //             if((int)$ci->symptom_screening==2 || $ci->symptom_screening=='2')
    //             {
    //                 $date = Carbon::parse($ci->date); 
    //                 $ci_month = $date->month;
    //                 $ci_year = $date->year;
                   
    //                  if($ci_year==$year){
    //                     if($month==13)
    //                      {
    //                          if($ci_month==1||$ci_month==2||$ci_month==3||$ci_month==4||$ci_month==5||$ci_month==6)
    //                          {
    //                              // $symptom_screening+=1;
    //                               array_push($symptom_screening_arr, $ci->symptom_screening);
                                
    //                          }
    //                      }
    //                      if($month==14)
    //                      {
    //                          if($ci_month==7||$ci_month==8||$ci_month==9||$ci_month==10||$ci_month==11||$ci_month==12)
    //                          {
    //                              // $symptom_screening+=1;
    //                               array_push($symptom_screening_arr, $ci->symptom_screening);
    //                          }
    //                      }
    //                       if($ci_month==$month)
    //                          {
    //                             // $symptom_screening+=1;
    //                               array_push($symptom_screening_arr, $ci->symptom_screening);
    //                          }
    //                   }
                    
                   
    //             }else{
    //               // $symptom_screening=0;
    //                  array_push($symptom_screening_arr, $ci->symptom_screening);
    //             }
    //         }
            
    //         $fam['sym_screening']=$symptom_screening;
    //         $fam['reg_date']=$count;
    //         $fam['diag']=$diagnosis;
    //     }
        
    //     if (in_array("2", $symptom_screening_arr)) {
    //       $symptom_screening=1;
    //     } else {
    //         $symptom_screening=0;
    //     }

    //     return $familymembers;
    // }
    
    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient by " . request("column"), $result)
        );
    }
    
    

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'dob' => 'required',
            'address' => 'required',
            'pre_enroll' => 'required',
            'id'=>'required'


        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->update(request()->all());
        $result = $this->patientService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is Saved", $result)
        );
    }


    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->patientService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is deleted", $result)
        );
    }

    
}
