<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

class PAController extends Controller
{
    private $paService;

    public function __construct()
    {
        parent::__construct();
        $this->paService = new \App\Service\Dashboard\PA;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        // $lastSerial = \App\Models\PA::where("township_id", request()->township_id)->orderBy("serial", "desc")->first();
        
        // return response()->json(
        //   $lastSerial
        // );
        
        $result = $this->paService->save(request()->all());
        $result = $this->paService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "PA is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->paService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All pas",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->paService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "PA by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->paService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "PA is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->paService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "PA is deleted", $result)
        );
    }

}
