<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class OutsideTownshipController extends Controller
{
    private $outsideTownshipService;

    public function __construct()
    {
        parent::__construct();
        $this->outsideTownshipService = new \App\Service\Dashboard\OutsideTownship;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->outsideTownshipService->save(request()->all());
        $result = $this->outsideTownshipService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Outside Township is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->outsideTownshipService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Outside Townships",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->outsideTownshipService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Outside Township by " . request("column"), $result)
        );
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->outsideTownshipService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Outside Township is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->outsideTownshipService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Outside Township is deleted", $result)
        );
    }
}
