<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class MemberController extends Controller
{
    private $memberService;

    public function __construct()
    {
        parent::__construct();
        $this->memberService = new \App\Service\Dashboard\Member;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "username" => "required",
            "role" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->memberService->getEach("username", request("username"));
        if ($result) {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, false, "Username already existed")
            );
        }


        $result = $this->memberService->save(request()->all());
        $result = $this->memberService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->memberService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All das",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->memberService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA by " . request("column"), $result)
        );
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "username" => "required",
            "role" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->memberService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->memberService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA is deleted", $result)
        );
    }
}
