<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

class LowSideEffectController extends Controller
{
    private $lowSideEffectService;

    public function __construct()
    {
        parent::__construct();
        $this->lowSideEffectService = new \App\Service\Dashboard\LowSideEffect;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "code" => "required",
            "eng_name" => "required",
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->lowSideEffectService->save(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Low Side Effect is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->lowSideEffectService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Low Side Effects",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->lowSideEffectService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Low Side Effect by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "code" => "required",
            "eng_name" => "required",
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->lowSideEffectService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Low Side Effect is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->lowSideEffectService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Low Side Effect is deleted", $result)
        );
    }

}
