<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\InnoDotsDate;
use Illuminate\Support\Carbon;
use Exception;

class InnoDotController extends Controller
{
    public function import(Request $request)
    {
        
        $request->validate([
            'data' => 'required|array',
            'data.*' => 'array',
        ]);
        
        $data = $request->input('data');
        
         DB::beginTransaction();
         $errors = [];
       
         foreach ($data as $row) {
        
              try {
                $formattedDate = Carbon::createFromFormat('Y-m-d', '1900-01-01')
                                ->addDays($row['Date'] - 2) 
                                ->format('Y-m-d');
                                
                             
                 $true=  InnoDotsDate::create([
                        'dots_patient_id' => $row['DOT_Patient_ID_GF'],
                        'volunteer_id' => $row['Volunteer_ID_GF'],
                        'date' =>$formattedDate,
                        'work_type' => $row['Work'],
                        //   'type' =>$row['Work']  == 'ဗွီဒီယိုခေါ်ခြင်းဖြင့်'? 1:2,
                        'status' => $row['Work_Status']== 'အောင်မြင်ပါသည်' ? 1 :2,
                        'high_side_effect' => $row['Actions'],
                        'video_link' => $row['VOT_Video_Link'],
                        'signature' => $row['Patient_Sign'],
                        'minor_side_effects'=>$row['Minor_Side_Effects'],
                        'major_side_effects'=>$row['Major_Side_Effects'],
                         
                    ]);
                    
                   
                } catch (\Exception $e) {
                   
                    $errors[] = ['row' => $row, 'error' => $e->getMessage()];
                    \Log::error('Error processing row: ' . json_encode($row) . '. Error: ' . $e->getMessage());
                }
        }
        
        

        
        if (empty($errors)) {
            DB::commit();
            return response()->json(['message' => 'All rows processed successfully'], 200);
        } else {
            DB::rollBack();
            return response()->json(['message' => 'Some rows failed', 'errors' => $errors], 400);
        }

    }
    
    public function processData(array $data)
{
    DB::beginTransaction();

    $errors = [];

    foreach ($data as $row) {
        try {
            YourModel::create([
                'column1' => $row['column1'],
                'column2' => $row['column2'],
                // Add more columns as needed
            ]);
        } catch (\Exception $e) {
            // Log error and continue with the next row
            $errors[] = ['row' => $row, 'error' => $e->getMessage()];
            \Log::error('Error processing row: ' . json_encode($row) . '. Error: ' . $e->getMessage());
        }
    }

    if (empty($errors)) {
        DB::commit();
        return response()->json(['message' => 'All rows processed successfully'], 200);
    } else {
        DB::rollBack();
        return response()->json(['message' => 'Some rows failed', 'errors' => $errors], 400);
    }
}
    
    public function export(Request $request)
    {
        
         $mytime = \Carbon\Carbon::now();;      
         return Excel::download(new \App\Exports\MDR_DOTSPatientExport($request), 'MDR_DOTSPatientExport'.$mytime->toDateTimeString().'.csv');

    }
}
