<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use \App\Models\HomeVisitActivity;
use \App\Models\Patient;

class HomeVisitActivityController extends Controller
{
    private $homeVisitService;

    public function __construct()
    {
        parent::__construct();
        $this->homeVisitService = new \App\Service\Dashboard\HomeVisit;
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->homeVisitService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
        
    //   try {
    //     $validate_result = $this->validateData([
    //         "month" => "required",
    //         "year" => "required",
    //     ], request()->all());
    
    //     if ($validate_result) {
    //         return $this->showValidateError();
    //     }
    
    //     $result = $this->homeVisitService->getAll(request()->all());
    
    //     return response()->json(
    //         $this->custom_response->create(
    //             \App\Enums\ResponseCode::Success,
    //             true,
    //             "All Home visit Activities",
    //             $result
    //         )
    //     );
    // } catch (\Throwable $e) {
    //      // Log the exception for debugging
    //     Log::error('An error occurred: ' . $e->getMessage());
    //     return response()->json([
    //         'error' => 'error'
    //     ]);
    // }

    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->homeVisitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE by " . request("column"), $result)
        );
    }
    
      public function export(Request $request)
      {
         $mytime = \Carbon\Carbon::now();
            return Excel::download(new \App\Exports\SideEffectExport($request),'SideEffectExport'.$mytime->toDateTimeString().'.csv');
      }
      
    // public function export(Request $request)
    // {
    //     $this->model=new \App\Models\HomeVisitActivity();
    //     $queries=$this->model->where("patient_id",null)
    //                         ->orderBy("created_at","desc")->get();

        
    //   foreach($queries as $query)
    //   {
          
    //         $year_length= Str::length($query->mdrtb_year);
    //         $code_length=Str::length($query->mdrtb_code);
                    
    //         $mdrtb_year=$query->mdrtb_year;
    //         $mdrtb_code=$query->mdrtb_code;
            
    //         $township_id=$query->township_id;
         
    //         //  if(str_contains($mdrtb_code, '/'))
    //         //  {
    //         //      $mdrtb_code=substr($mdrtb_code, 0,2);
    //         //      $mdrtb_code=(int)$mdrtb_code;
                 
    //         //  }
            
    //         if($year_length==4)
    //         {
    //             $mdrtb_year= substr ($mdrtb_year, -2);
    //         }
            
    //         if($code_length==3)
    //         {
    //              $mdrtb_code=(int)$mdrtb_code;
    //         }
            
    //         $mdrtb_year=(int)$mdrtb_year;
            
    //         $patient=Patient::where('mdrtb_reg_no',$mdrtb_code)
    //                           ->where('mdrtb_reg_year',$mdrtb_year)
    //                             ->where('township_id',$township_id)
    //                             ->first();
                                
    //       if(isset($patient))
    //       {
    //               $query->patient_id=$patient->id;
    //               $query->treatment_start_date=$patient->treatment_startdate;
    //               $query->mdrtb_year=$patient->mdrtb_reg_year;
    //               $query->mdrtb_code=$patient->mdrtb_reg_no;
                 
    //               $query->update();
    //       }
           
    //   }
       
    //   return 'true';
        
          
    //     if ($request->start_date && $request->end_date)
    //         {
    //             $query->whereBetween('date', [$request->start_date, $request->end_date]);  
    //         }
            
    //     if ($request->township_id)
    //         {
    //             $query->where("township_id",$request->township_id);        
    //         }
    //         else if ($request->township_group_id)
    //         {
    //             if($request->township_group_id=='6' || $request->township_group_id==6)
    //             {
    //                  $query->whereHas("township",function($query) use ($request) {
    //                     $query->where("township_group_id",1)
    //                         ->OrWhere("township_group_id",2)
    //                         ->orderBy("id");
    //                 });
    //             }
    //             else{
    //                 $query->whereHas("township",function($query) use ($request) {
    //                 $query->where("township_group_id",$request->township_group_id)->orderBy("id");
    //                 });
    //             }
                
                
    //         }
            
    //      $side_effects= $query->first();
         
    //      return $side_effects->patient->mdrtb_regiments[0]->mdrtb_regiment_id;
         
    //      foreach($side_effects as $s)
    //      {
    //          $mdrtb_code= $s->mdrtb_code;
    //          $mdrtb_year=$s->mdrtb_year;
    //          $township_id=$s->township_id;
             
    //          $patient=Patient::where('mdrtb_reg_no', $mdrtb_code)
    //                           ->where('mdrtb_reg_year','21')
    //                             ->where('township_id', $township_id)
    //                             ->update(['patient_id' => 105]);
    //         return $patient;
    //      }
         
        
    //     $alldata=$this->getAll($data);
      

    //     return $alldata;

    // }
       
    public function checked()
    {
        $model = \App\Models\HomeVisitActivity::find(request("id"));
        $model->checked = request('checked');
        $model->update();
        return response()->json(["success" => true, "data" => $model]);
    }
}
