<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class HeActivityController extends Controller
{
    private $heService;

    public function __construct()
    {
        parent::__construct();
       $this->heService = new \App\Service\Dashboard\He;
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",

        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        
        $result =  $this->heService->getAll(request()->all());
        
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
    }
    
    public function export()
    {
        //  $this->heService = new \App\Service\Dashboard\He;
        //  $result =  $this->heService->getAll(request()->all());
        //  return $result;
        
         $mytime = \Carbon\Carbon::now();;      
        return Excel::download(new \App\Exports\DashboardHEActivityExport(request()->all()), 'HEActivityExport'.$mytime->toDateTimeString().'.csv');
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->heService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE by " . request("column"), $result)
        );
    }

    public function checked()
    {
        $model = \App\Models\HeActivity::find(request("id"));
        $model->checked = request('checked');
        $model->update();
        return response()->json(["success" => true, "data" => $model]);
    }
}
