<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class FamilyMemberController extends Controller
{
    private $familyMemberService;

    public function __construct()
    {
        parent::__construct();
        $this->familyMemberService = new \App\Service\Dashboard\FamilyMember;
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member by patient ID " . request("patient_id"), $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member by " . request("column"), $result)
        );
    }
}
