<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Exception;

class DataImportController extends Controller
{
    public function import()
    {
        $patients = request()->all();
        
        foreach ($patients["data"] as $patient) {

            // if (strlen($patient["mdrtb_reg_no"]) == 2) {
                // try {
                    $township = \App\Models\Township::where("short_code", $patient["townshipCode"])->first();
                    $patientImport = new \App\Models\Patient;
                    $patientImport->mdrtb_reg_no = $patient["mdrtb_reg_no"];
                    $patientImport->mdrtb_reg_year = $patient["mdrtb_reg_year"];
                    $patientImport->name = $patient["name"];
                    $patientImport->sex = $patient["sex"];
                    $patientImport->dob = "2020-12-10"; // calculate from $patient["age"]
                    $patientImport->address = $patient["address"] ? $patient["address"] : "-";
                    $patientImport->type_of_patient = $patient["type_of_patient"];
                    $patientImport->type_of_tb = $patient["type_of_tb"];
                    $patientImport->treatment_startdate = \Carbon\Carbon::parse($patient["treatment_startdate"])->toDateString();
                    $patientImport->pre_enroll = $patient["pre_enroll"];
                    if ($township) {
                        $patientImport->township_id = $township->id;
                        $patientImport->hiv_status = $patientImport["hiv_status"];
                        if ($patientImport->hiv_status == 2) {
                            $patientImport->hiv_result = $patientImport["hiv_result"];
                            if ($patientImport->hiv_result == 2) {
                                $patientImport->art_rx = $patientImport["art_rx"];
                                $patientImport->cpt_rx = $patientImport["cpt_rx"];
                            }
                        }
                        $patientImport->outside_tsp = $patient["outside_tsp"];
                        if ($patientImport->outside_tsp == 2) {
                            $patientImport->outside_tsp_name = $patient["outside_tsp_name"];
                        }

                        $patientImport->t_in = $patient["t_in"];
                        if ($patientImport->t_in == 2) {
                            $patientImport->t_in_date == \Carbon\Carbon::parse($patient["t_in_date"])->toDateString();
                        }



                        if ($patient["finished_date"]) {
                            $patientImport->treatment_finish = 2;
                            $patientImport->finished_date = \Carbon\Carbon::parse($patient["finished_date"])->toDateString();
                            $patientImport->final_outcome = $patient["final_outcome"];
                            $patientImport->final_outcome_date = \Carbon\Carbon::parse($patient["final_outcome_date"])->toDateString();
                        }



                        $patientImport->save();
                        if ($patient["regimen"]) {
                            $regiMenInput = new \App\Models\PatientMdrtbRegiment;
                            $regiMenInput->patient_id = $patientImport->id;
                            $regiMenInput->mdrtb_regiment_id = $patient["regimen"];
                            $regiMenInput->date = $patientImport->treatment_startdate;
                            $regiMenInput->save();
                        }

                        $preEnrolls = json_decode(json_encode($patient["pre_enrolls"]));
                        foreach ($preEnrolls as $index => $preEnrol) {
                            $preEnrollSupport = new \App\Models\PreEnrollSupport;
                            $preEnrollSupport->nominated = $preEnrol->nomindated;
                            $preEnrollSupport->support_month = $preEnrol->month;
                            $preEnrollSupport->support_year = $preEnrol->year;
                            if ($preEnrollSupport->nominated == 2) {
                                $preEnrollSupport->support = $preEnrol->support;
                                if ($preEnrollSupport->support == 2) {
                                    $preEnrollSupport->date =  \Carbon\Carbon::parse($preEnrol->date)->toDateString();
                                }
                            }
                            if ($index == 0) {
                                $preEnrollSupport->month_type = 1;
                            } else if ($index == 1) {
                                $preEnrollSupport->month_type = 2;
                            }
                            $preEnrollSupport->patient_id = $patientImport->id;
                            $preEnrollSupport->save();
                        }

                        $enrolls = json_decode(json_encode($patient["supports"]));
                        foreach ($enrolls as $index => $enroll) {
                            $enrollImport = new \App\Models\EnrollSupport;
                            $yes = $enroll->received == "Yes" ? 2 : 1;
                            if ($yes == 2) {
                                $enrollImport->nominated = $yes;
                                $enrollImport->support = 2;
                                // if ($enroll->date != "Yes" && $enroll->date != "No") {
                                //     $enrollImport->date =  \Carbon\Carbon::parse($enroll->date)->toDateString();
                                // } else {
                                //     $enroll->date = "2020-12-12";
                                // }
                            } else {
                                $enrollImport->nominated = $yes;
                                $enrollImport->support = 1;
                            }
                            $enrollImport->support_month = $enroll->month;
                            $enrollImport->support_year = $enroll->year;

                            $enrollImport->patient_id = $patientImport->id;
                            if ($enrollImport->support_month && $enrollImport->support_year) {
                                $enrollImport->save();
                            }
                        }

                        $dotsPatient = new \App\Models\DOTSPatient;
                        $dotsPatient->patient_id = $patientImport->id;
                        if ($patient["dots_startdate"]) {
                            $dotsPatient->dots_startdate = \Carbon\Carbon::parse($patient["dots_startdate"])->toDateString();
                        } else {
                            $dotsPatient->dots_startdate = \Carbon\Carbon::parse($patient["treatment_startdate"])->toDateString();
                        }
                        $dotsPatient->dots_enddate = \Carbon\Carbon::parse($patient["dots_enddate"])->toDateString();
                        $dotsPatient->dots_app_status = 1;
                        $dotsPatient->save();

                        $dotsMainActity = new \App\Models\DotsMainActivity;
                        $dotsMainActity->dots_patient_id = $dotsPatient->id;
                        if ($patient["dots_startdate"]) {
                            $dotsMainActity->dots_startdate = \Carbon\Carbon::parse($patient["dots_startdate"])->toDateString();
                        } else {
                            $dotsMainActity->dots_startdate = \Carbon\Carbon::parse($patient["treatment_startdate"])->toDateString();
                        }
                        if ($patient["dots_enddate"]) {
                            $dotsMainActity->dots_enddate = \Carbon\Carbon::parse($patient["dots_enddate"])->toDateString();
                        }
                        $dotsMainActity->dots_app_status = 1;
                        $dotsMainActity->save();
                    }
                // } catch (Exception $e) {
                //     exit(json_encode(array(
                //         "patient" => $patient,
                //         "error" => $e->getMessage()
                //     )));
                // }
            // }
        }
        return "success";
    }
}
