<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class DOTSVolunteerController extends Controller
{
    private $dotsVolunteerController;

    public function __construct()
    {
        parent::__construct();
        $this->dotsVolunteerController = new \App\Service\Dashboard\DOTSVolunteer;
    }


    public function get()
    {
        $result =  $this->dotsVolunteerController->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS Volunteer",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsVolunteerController->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS  Volunteer by " . request("column"), $result)
        );
    }
}
