<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class DOTSVisitReportController extends Controller
{
    private $dotsVisitReportService;

    public function __construct()
    {
        parent::__construct();
        $this->dotsVisitReportService = new \App\Service\Dashboard\DOTSVisitReport;
    }


    public function get()
    {
        $validate_result = $this->validateData([
            "dots_patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->dotsVisitReportService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS Visit Report",
                $result
            )
        );
    }

    
}
