<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use Carbon\Carbon;
use DB;

class DOTSPatientController extends Controller
{
    private $dotsPatientService;

    public function __construct()
    {
        parent::__construct();
        $this->dotsPatientService = new \App\Service\Dashboard\DOTSPatient;
    }
    
      public function export(Request $request)
      {
            $mytime = \Carbon\Carbon::now();;      
            return Excel::download(new \App\Exports\DOTSPatientExport($request), 'DOTSPatientExport'.$mytime->toDateTimeString().'.csv');
       }
   
    public function testing(Request $request)
    {
        $appCount = \App\Models\DOTSPatient::whereHas("patient", function ($query){
            $query->where("township_id","8");
        })->where(function ($query) {
            $query->whereHas("dots_visit_date", function ($query) {
                $query->whereMonth("date","3")->whereYear("date","2024");
            });
        })->with('patient')->get();
        
        $a=[];


        foreach($appCount as $app)
        {
            array_push($a, $app->patient->name);
        }
        
        return  $a;
    }
    
    public function get()
    {
        $result =  $this->dotsPatientService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS Patient Activities",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsPatientService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Patient by " . request("column"), $result)
        );
    }
    
   

    
}
