<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class DOTSActivityController extends Controller
{
    private $dotsActivityService;

    public function __construct()
    {
        parent::__construct();
        $this->dotsActivityService = new \App\Service\Dashboard\DOTSActivity;
    }


    public function get()
    {
        $result =  $this->dotsActivityService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS  Activities",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsActivityService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS  Activity by " . request("column"), $result)
        );
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'dots_startdate' => 'required',
            'dots_patient_id' => 'required',
            'volunteer_id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsActivityService->save(request()->all());
        $result = $this->dotsActivityService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Activity is saved", $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'dots_startdate' => 'required',
            'dots_enddate' => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsActivityService->update(request()->all());
        $result = $this->dotsActivityService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Activity is Update", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->dotsActivityService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Activity is deleted", $result)
        );
    }
}
