<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

class DAController extends Controller
{
    private $daService;

    public function __construct()
    {
        parent::__construct();
        $this->daService = new \App\Service\Dashboard\DA;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "township_group_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->daService->save(request()->all());
        $result = $this->daService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->daService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All das",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->daService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
            "township_group_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->daService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->daService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA is deleted", $result)
        );
    }

}
