<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class CounselingActivityController extends Controller
{
    private $counselingService;

    public function __construct()
    {
        parent::__construct();
        $this->counselingService = new \App\Service\Dashboard\Couseling;
    }



    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->counselingService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Counseling Activities",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->counselingService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling by " . request("column"), $result)
        );
    }

    public function checked()
    {
        $model = \App\Models\CounselingActivity::find(request("id"));
        $model->checked = request('checked');
        $model->update();
        return response()->json(["success" => true, "data" => $model]);
    }
}
