<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;

class ClinicController extends Controller
{
    private $clinicService;

    public function __construct()
    {
        parent::__construct();
        $this->clinicService = new \App\Service\Dashboard\Clinic;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->clinicService->save(request()->all());
        $result = $this->clinicService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Account is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->clinicService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All accounts",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->clinicService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Account by " . request("column"), $result)
        );
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->clinicService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Account is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->clinicService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Account is deleted", $result)
        );
    }
}
